% standard kaleido loader 
function [CameraLabels, ImageOriginal, Cameras, CamerasLevels, CamerasK, CamerasR, CamerasT] = load_full_kaleido_data(dirname)
    camera_labels_file = [dirname  '/camera_labeled.png'];
    CameraLabels = imread(camera_labels_file);

    image_original = [dirname '/image.png'];
    ImageOriginal = double(rgb2gray(imread(image_original)));
    ImageOriginal = uint8(255*ImageOriginal./max(max(ImageOriginal(:,:))));
    ImageOriginal = single(ImageOriginal);
    
    fid = fopen([dirname '/cameras_index.txt']);
    
    Cameras=[];
    CamerasLevels=[];
    CamerasK=[];
    CamerasR=[];
    CamerasT=[];
    i=0;
    while ~feof(fid)        
        i=i+1;
        CamInd = fscanf(fid, '%d', 1) + 1;
        CamLevel = fscanf(fid, '%d', 1);
        CamK = fscanf(fid, '%f', 9);
        CamR = fscanf(fid, '%f', 9);
        CamT = fscanf(fid, '%f', 3);        
        
        if ~feof(fid)            
            Cameras(i)= CamInd;
            CamerasLevels(i)=CamLevel;

            for i1=1:1:3
                for j1=1:1:3
                    CamerasK(i,i1,j1)=CamK((i1-1)*3+j1);
                    CamerasR(i,i1,j1)=CamR((i1-1)*3+j1);
                end
            end            
            
            CamerasT(i,1)=CamT(1);
            CamerasT(i,2)=CamT(2);
            CamerasT(i,3)=CamT(3);
        end        
    end
    fclose(fid);      

    % now you have everything loaded:
    
    %   Original image: 
    %       ImageOriginal - original image with compensated pixels (in the original image higher reflections points are darker)
    %   Cameras labels:
    %       CameraLabels - image with the same size as original with values at pixels equal to the corresponding camera index
    %   Virtual cameras list:
    %       Cameras - camera index value
    %       CamerasLevels - reflecton level of the virtual camera
    %       CamerasK - K matrix of the virtual camera
    %       CamrasR - R matrix
    %       CamerasT - T vector
    
    
    
end
